#include "sprite.h"

Sprite::Sprite()
{
    initialiser();
}

Sprite::~Sprite()
{
    for ( int i=0 ; i < MAX_ETAT ; i++ )
        for ( int j=0 ; j < MAX_DIRECTION ; j++ )
                for ( int k=0 ; k < MAX_ANIMATION ; k++ )
                     if ( m_pBmp[k][j][i] != NULL )
                          destroy_bitmap(m_pBmp[k][j][i]);           
}

void Sprite::initialiser()
{
    m_bVisible=true;
    m_bAnimer=false;
    m_bTransparent=false;
    m_bCache=false;
    m_iXCache=0;
    m_iYCache=0;
    
    m_iDirection=0;
    m_iAnimation=0;
    m_iEtat=0;
    m_iMaxEtat=0;
    
    for ( int i=0 ; i < MAX_ETAT ; i++ )
    {
        m_Anim[i].m_iMaxAnim=0;
        m_Anim[i].m_iMaxDirec=0;
        m_Anim[i].m_iSpeed=0;
        m_Anim[i].m_szNomAnim=NULL;
        m_Anim[i].m_iType=0;
        for ( int j=0 ; j < MAX_DIRECTION ; j++ )
        {
                m_Anim[i].m_iAjoutX[j]=0;
                m_Anim[i].m_iAjoutY[j]=0;
        }
    }
        
    for ( int i=0 ; i < MAX_ETAT ; i++ )
        for ( int j=0 ; j < MAX_DIRECTION ; j++ )
             for ( int k=0 ; k < MAX_ANIMATION ; k++ )
                  m_pBmp[k][j][i]=NULL;
}   

void Sprite::setBmp(char *szNom,const int iAnimation,const int iDirection,const int iEtat)
{
    PALETTE pal;
    BITMAP *tmp;
    tmp=load_bitmap(szNom,pal);
    m_pBmp[iAnimation][iDirection][iEtat]=create_video_bitmap(tmp->w,tmp->h);
    blit(tmp,m_pBmp[iAnimation][iDirection][iEtat],0,0,0,0,tmp->w,tmp->h);
    destroy_bitmap(tmp);
}

void Sprite::setBmpEtat(char *szNom, const int iLargeur,const int iHauteur,const int iNbreCol,
                                            const int iNbreLigne,const int iEtat)
{
    PALETTE pal;
    BITMAP *full=load_bitmap(szNom,pal);
    for ( int i=0 ; i < iNbreLigne ; i++ )
    {
        for ( int j=0 ; j < iNbreCol ; j++ )
        {
                m_pBmp[j][i][iEtat]=create_video_bitmap(iLargeur,iHauteur);
                blit(full,m_pBmp[j][i][iEtat],j*iLargeur,i*iHauteur,0,0,iLargeur,iHauteur);
        }
    }
    destroy_bitmap(full);
    
    m_Anim[iEtat].m_iMaxAnim=iNbreCol;
    m_Anim[iEtat].m_iMaxDirec=iNbreLigne;
}

void Sprite::addBmpEtat(char *szNom, const int iLargeur,const int iHauteur,const int iNbreCol,
                        const int iNbreLigne,const int iSpeed,const int iType,char *szNomAnim)
{
    if ( m_iMaxEtat < MAX_ETAT )
    {
        
        PALETTE pal;
        BITMAP *full=load_bitmap(szNom,pal);
        for ( int i=0 ; i < iNbreLigne ; i++ )
        {
            for ( int j=0 ; j < iNbreCol ; j++ )
            {
                m_pBmp[j][i][m_iMaxEtat]=create_video_bitmap(iLargeur,iHauteur);
                blit(full,m_pBmp[j][i][m_iMaxEtat],j*iLargeur,i*iHauteur,0,0,iLargeur,iHauteur);
            }
        }
        destroy_bitmap(full);
    
        m_Anim[m_iMaxEtat].m_iMaxAnim=iNbreCol;
        m_Anim[m_iMaxEtat].m_iMaxDirec=iNbreLigne;
        
        setSpeedAnim(m_iMaxEtat,iSpeed,szNomAnim);
        m_Anim[m_iMaxEtat].m_iType=iType;

        m_iMaxEtat++;
    }
}

void Sprite::charger(BITMAP **pTemp,const int iX,const int iY)
{
    if ( m_bVisible )
    {
        if ( m_bTransparent )
                draw_trans_sprite(*pTemp,m_pBmp[m_iAnimation][m_iDirection][m_iEtat],
                iX+m_Anim[m_iEtat].m_iAjoutX[m_iDirection],iY+m_Anim[m_iEtat].m_iAjoutY[m_iDirection]);
        else
        {
           if ( ! m_bCache )
                draw_sprite(*pTemp,m_pBmp[m_iAnimation][m_iDirection][m_iEtat],
                iX+m_Anim[m_iEtat].m_iAjoutX[m_iDirection],iY+m_Anim[m_iEtat].m_iAjoutY[m_iDirection]);
           else 
                      blit(m_pBmp[m_iAnimation][m_iDirection][m_iEtat],*pTemp,
                       0,0,iX+m_Anim[m_iEtat].m_iAjoutX[m_iDirection],iY+m_Anim[m_iEtat].m_iAjoutY[m_iDirection],m_iXCache,m_iYCache);

        }
    }
}

void Sprite::runAnimer()
{
    if ( m_bAnimer ) 
    {
        if ( m_Anim[m_iEtat].m_iType == 1 )
        {
            if ( m_Anim[m_iEtat].m_szNomAnim != NULL )
            {
                if ( g_SGTimer.get(m_Anim[m_iEtat].m_szNomAnim)->pret() )
                {            
                     m_iAnimation++;
                     if ( m_iAnimation >= m_Anim[m_iEtat].m_iMaxAnim )
                                m_iAnimation=0;
                }
            }
        }
        else if ( m_Anim[m_iEtat].m_iType == 2 )
        {
            if ( m_Anim[m_iEtat].m_szNomAnim != NULL )
            {
                if ( g_SGTimer.get(m_Anim[m_iEtat].m_szNomAnim)->pret() )
                {            
                     if ( m_iAnimation < m_Anim[m_iEtat].m_iMaxAnim-1 ) m_iAnimation++;
                     else stopAnimer();
                }
            }
        }
    }
}

void Sprite::setSpeedAnim(const int iEtat,const int iSpeed,char *szNom)
{
    m_Anim[iEtat].m_iSpeed=iSpeed ;
    m_Anim[iEtat].m_szNomAnim=szNom;
    g_SGTimer.add(szNom,iSpeed);
}

void Sprite::setMaxEtat(const int iMaxEtat)
{
    if ( iMaxEtat <= MAX_ETAT )
    {
        m_iMaxEtat=iMaxEtat;
    }
}

void Sprite::setEtat(const int iEtat)
{
    if ( iEtat < m_iMaxEtat )
    {
        m_iEtat=iEtat;
    }
}

void Sprite::changerEtat(const int iEtat)
{
    if ( iEtat < m_iMaxEtat )
    {
        m_bAnimer=false;
        m_iEtat=iEtat;
        m_iAnimation=0;
    }
}

void Sprite::setDirection(const int iDirection)
{ 
    if ( iDirection < m_Anim[m_iEtat].m_iMaxDirec )
        m_iDirection=iDirection ; 
}

void Sprite::setAnimation(const int iAnimation) 
{ 
    if ( iAnimation < m_Anim[m_iEtat].m_iMaxAnim )
        m_iAnimation=iAnimation;
}

bool Sprite::animationFinie()
{
    if ( g_SGTimer.get(m_Anim[m_iEtat].m_szNomAnim)->pret() )
        if ( m_iAnimation >= m_Anim[m_iEtat].m_iMaxAnim-1 ) return true;
    return false;
}

void Sprite::setAjoutAnim(const int iEtat,const int iDirection,const int iAjoutX,const int iAjoutY)
{
    if ( iEtat < m_iMaxEtat && iDirection < m_Anim[m_iEtat].m_iMaxDirec )
    {
        m_Anim[iEtat].m_iAjoutX[iDirection]=iAjoutX;
        m_Anim[iEtat].m_iAjoutY[iDirection]=iAjoutY;
    }
}

int Sprite::getHauteur() const 
{
    if ( m_pBmp[0][0][0] != NULL )
        return m_pBmp[0][0][0]->h;
}

int Sprite::getLargeur() const 
{
    if ( m_pBmp[0][0][0] != NULL )
        return m_pBmp[0][0][0]->w;
}

void Sprite::setCache(const int iX,const int iY)
{
    m_bCache=true;
    m_iXCache=iX;
    m_iYCache=iY;
}

void Sprite::changeColor(const int iAnim,const int iDirec,const int iEtat,const int iX,const int iY,const int iColor)
{
    int iOldColor=getpixel(m_pBmp[iAnim][iDirec][iEtat],iX,iY);
    for ( int i=0 ; i < m_iMaxEtat ; i++ )
        for ( int j=0 ; j < m_Anim[i].m_iMaxDirec ; j++ )
             for ( int k=0 ; k < m_Anim[i].m_iMaxAnim ; k++ )
                 for ( int x=0 ; x < m_pBmp[k][j][i]->w ; x++ )
                      for ( int y=0 ; y < m_pBmp[k][j][i]->h ; y++ )
                           if ( getpixel(m_pBmp[k][j][i],x,y) == iOldColor )
                               putpixel(m_pBmp[k][j][i],x,y,iColor);
}

